/**************************************************************************/
/*                                                                        */
/*                                 OCaml                                  */
/*                                                                        */
/*             Xavier Leroy, projet Cristal, INRIA Rocquencourt           */
/*                                                                        */
/*   Copyright 1996 Institut National de Recherche en Informatique et     */
/*     en Automatique.                                                    */
/*                                                                        */
/*   All rights reserved.  This file is distributed under the terms of    */
/*   the GNU Lesser General Public License version 2.1, with the          */
/*   special exception on linking described in the file LICENSE.          */
/*                                                                        */
/**************************************************************************/

#include <caml/mlvalues.h>
#include <caml/signals.h>
#include "caml/unixsupport.h"

CAMLprim value caml_unix_close(value vfd)
{
  int fd = Int_val(vfd);
  int ret;
  caml_enter_blocking_section();
  ret = close(fd);
  caml_leave_blocking_section();
  if (ret == -1) caml_uerror("close", Nothing);
  return Val_unit;
}
