/* This file is generated by tools/gen_sizeclasses.ml */
#define POOL_WSIZE 4096
#define POOL_HEADER_WSIZE 4
#define SIZECLASS_MAX 128
#define NUM_SIZECLASSES 32

typedef unsigned char sizeclass;
static_assert(NUM_SIZECLASSES < (1 << (CHAR_BIT * sizeof(sizeclass))), "");

/* The largest size for this size class.
   (A gap is left after smaller objects) */
static const unsigned int wsize_sizeclass[NUM_SIZECLASSES] =
{ /*  0:*/ 1, 2, 3, 4, 5,
  /*  5:*/ 6, 7, 8, 10, 12,
  /* 10:*/ 14, 16, 17, 19, 22,
  /* 15:*/ 25, 28, 32, 33, 37,
  /* 20:*/ 42, 47, 53, 59, 65,
  /* 25:*/ 73, 81, 89, 99, 108,
  /* 30:*/ 118, 128 };

/* The number of padding words to use, at the beginning of a pool
   of this sizeclass, to reach exactly POOL_WSIZE words. */
static const unsigned char wastage_sizeclass[NUM_SIZECLASSES] =
{ /*  0:*/ 0, 0, 0, 0, 2,
  /*  5:*/ 0, 4, 4, 2, 0,
  /* 10:*/ 4, 12, 12, 7, 0,
  /* 15:*/ 17, 4, 28, 0, 22,
  /* 20:*/ 18, 3, 11, 21, 62,
  /* 25:*/ 4, 42, 87, 33, 96,
  /* 30:*/ 80, 124 };

/* Map from (positive) object sizes to size classes. */
static const sizeclass sizeclass_wsize[SIZECLASS_MAX + 1] =
{ /*  0:*/ 255, 0, 1, 2, 3,
  /*  5:*/ 4, 5, 6, 7, 8,
  /* 10:*/ 8, 9, 9, 10, 10,
  /* 15:*/ 11, 11, 12, 13, 13,
  /* 20:*/ 14, 14, 14, 15, 15,
  /* 25:*/ 15, 16, 16, 16, 17,
  /* 30:*/ 17, 17, 17, 18, 19,
  /* 35:*/ 19, 19, 19, 20, 20,
  /* 40:*/ 20, 20, 20, 21, 21,
  /* 45:*/ 21, 21, 21, 22, 22,
  /* 50:*/ 22, 22, 22, 22, 23,
  /* 55:*/ 23, 23, 23, 23, 23,
  /* 60:*/ 24, 24, 24, 24, 24,
  /* 65:*/ 24, 25, 25, 25, 25,
  /* 70:*/ 25, 25, 25, 25, 26,
  /* 75:*/ 26, 26, 26, 26, 26,
  /* 80:*/ 26, 26, 27, 27, 27,
  /* 85:*/ 27, 27, 27, 27, 27,
  /* 90:*/ 28, 28, 28, 28, 28,
  /* 95:*/ 28, 28, 28, 28, 28,
  /*100:*/ 29, 29, 29, 29, 29,
  /*105:*/ 29, 29, 29, 29, 30,
  /*110:*/ 30, 30, 30, 30, 30,
  /*115:*/ 30, 30, 30, 30, 31,
  /*120:*/ 31, 31, 31, 31, 31,
  /*125:*/ 31, 31, 31, 31 };
