# 19 "ocamltest/tsl_lexer.mll"
 
open Tsl_parser

let comment_start_pos = ref []
let has_comments = ref false

let lexer_error message =
  failwith (Printf.sprintf "Tsl lexer: %s" message)

# 12 "ocamltest/tsl_lexer.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base =
   "\000\000\248\255\249\255\000\000\001\000\254\255\001\000\006\000\
    \006\000\012\000\000\000\000\000\000\000\000\000\000\000\001\000\
    \000\000\000\000\000\000\252\255\013\000\002\000\002\000\002\000\
    \003\000\001\000\003\000\001\000\001\000\001\000\250\255\080\000\
    \235\255\236\255\237\255\239\255\240\255\241\255\165\000\243\255\
    \000\000\247\255\004\000\247\000\006\000\254\255\007\000\017\000\
    \017\000\019\000\004\000\008\000\010\000\004\000\002\000\005\000\
    \002\000\002\000\013\000\003\000\059\000\025\001\035\000\055\000\
    \058\000\005\000\012\001\011\000\248\255\251\255\024\000\006\000\
    \025\000\024\000\026\000\016\000\047\000\046\000\040\000\038\000\
    \031\000\001\000\131\000\041\001\103\000\252\000\009\001\100\000\
    \244\255\018\001\252\255\045\000\020\001\062\001\049\000\197\000\
    \254\255\065\001\251\255\252\255\050\000\253\255\013\000\022\000\
    \255\255\254\255\213\000\090\001\252\255\004\000\001\000\027\002\
    \111\002\060\000\005\000\224\000\017\001\110\000\022\001\036\001\
    \195\002";
  Lexing.lex_backtrk =
   "\000\000\255\255\255\255\006\000\006\000\255\255\006\000\000\000\
    \255\255\255\255\255\255\255\255\255\255\002\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \004\000\255\255\255\255\255\255\255\255\255\255\255\255\000\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\013\000\255\255\
    \019\000\255\255\019\000\009\000\019\000\255\255\019\000\000\000\
    \255\255\255\255\255\255\255\255\255\255\002\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\003\000\010\000\009\000\255\255\255\255\017\000\255\255\
    \255\255\255\255\255\255\005\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\006\000\
    \255\255\255\255\255\255\002\000\000\000\001\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\004\000\255\255\004\000\004\000\
    \255\255\255\255\255\255\255\255\255\255\003\000\003\000\003\000\
    \000\000\255\255\255\255\255\255\001\000\255\255\255\255\002\000\
    \255\255";
  Lexing.lex_default =
   "\002\000\000\000\000\000\255\255\255\255\000\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\000\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\000\000\033\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\255\255\000\000\
    \255\255\000\000\255\255\255\255\255\255\000\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\059\000\059\000\059\000\059\000\059\000\
    \059\000\059\000\255\255\255\255\000\000\000\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\081\000\081\000\081\000\081\000\081\000\081\000\081\000\
    \000\000\092\000\000\000\255\255\092\000\255\255\255\255\255\255\
    \000\000\098\000\000\000\000\000\255\255\000\000\255\255\255\255\
    \000\000\000\000\255\255\108\000\000\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\115\000\115\000\255\255\118\000\118\000\
    \255\255";
  Lexing.lex_trans =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\007\000\005\000\005\000\007\000\006\000\008\000\007\000\
    \005\000\045\000\007\000\008\000\048\000\009\000\020\000\000\000\
    \009\000\020\000\047\000\045\000\049\000\047\000\048\000\049\000\
    \007\000\072\000\072\000\115\000\072\000\072\000\007\000\115\000\
    \003\000\082\000\020\000\009\000\009\000\020\000\070\000\004\000\
    \049\000\047\000\060\000\049\000\060\000\067\000\105\000\093\000\
    \072\000\072\000\094\000\093\000\099\000\088\000\094\000\106\000\
    \104\000\117\000\015\000\026\000\055\000\011\000\016\000\022\000\
    \027\000\051\000\056\000\073\000\017\000\028\000\057\000\018\000\
    \029\000\058\000\060\000\012\000\013\000\023\000\024\000\019\000\
    \030\000\047\000\045\000\052\000\047\000\046\000\053\000\014\000\
    \010\000\021\000\025\000\054\000\059\000\061\000\060\000\050\000\
    \063\000\060\000\060\000\074\000\071\000\071\000\075\000\076\000\
    \047\000\077\000\034\000\078\000\079\000\080\000\081\000\038\000\
    \042\000\117\000\043\000\040\000\041\000\038\000\038\000\044\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\064\000\035\000\082\000\039\000\065\000\082\000\
    \118\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\082\000\085\000\083\000\000\000\038\000\
    \000\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\037\000\038\000\036\000\096\000\000\000\
    \000\000\096\000\038\000\038\000\000\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\099\000\
    \000\000\000\000\106\000\000\000\000\000\096\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \001\000\255\255\116\000\255\255\038\000\255\255\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \068\000\067\000\061\000\255\255\082\000\061\000\069\000\066\000\
    \066\000\066\000\066\000\066\000\066\000\066\000\066\000\066\000\
    \066\000\082\000\083\000\116\000\090\000\083\000\255\255\255\255\
    \119\000\061\000\255\255\255\255\066\000\066\000\066\000\066\000\
    \066\000\066\000\066\000\066\000\066\000\066\000\119\000\093\000\
    \060\000\083\000\093\000\099\000\000\000\000\000\100\000\086\000\
    \032\000\082\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\087\000\093\000\000\000\
    \000\000\000\000\000\000\000\000\255\255\000\000\000\000\255\255\
    \000\000\103\000\000\000\102\000\000\000\062\000\091\000\000\000\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\084\000\000\000\000\000\
    \000\000\111\000\000\000\255\255\000\000\109\000\000\000\112\000\
    \111\000\000\000\111\000\111\000\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\000\000\000\000\000\000\110\000\
    \000\000\000\000\095\000\111\000\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\000\000\000\000\000\000\
    \000\000\111\000\000\000\111\000\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\255\255\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\255\255\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\255\255\255\255\000\000\255\255\000\000\255\255\000\000\
    \000\000\255\255\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\255\255\000\000\000\000\000\000\
    \000\000\255\255\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\101\000\120\000\000\000\000\000\000\000\113\000\000\000\
    \120\000\120\000\000\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\000\000\000\000\000\000\
    \114\000\000\000\255\255\000\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\000\000\000\000\
    \000\000\000\000\120\000\000\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\112\000\000\000\
    \000\000\000\000\113\000\000\000\112\000\112\000\000\000\112\000\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\000\000\000\000\000\000\114\000\000\000\000\000\000\000\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\000\000\000\000\000\000\000\000\112\000\000\000\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\120\000\000\000\000\000\000\000\113\000\000\000\
    \120\000\120\000\000\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\000\000\000\000\000\000\
    \114\000\000\000\000\000\000\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\000\000\000\000\
    \000\000\000\000\120\000\000\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000";
  Lexing.lex_check =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\006\000\000\000\000\000\006\000\007\000\
    \008\000\046\000\007\000\008\000\046\000\009\000\020\000\255\255\
    \009\000\020\000\047\000\048\000\049\000\047\000\048\000\049\000\
    \000\000\070\000\072\000\110\000\070\000\072\000\007\000\114\000\
    \000\000\081\000\003\000\004\000\009\000\020\000\042\000\000\000\
    \044\000\047\000\059\000\049\000\065\000\067\000\102\000\091\000\
    \070\000\072\000\091\000\094\000\100\000\040\000\094\000\100\000\
    \103\000\109\000\014\000\025\000\054\000\010\000\015\000\021\000\
    \026\000\050\000\055\000\071\000\016\000\027\000\056\000\017\000\
    \028\000\057\000\062\000\011\000\012\000\022\000\023\000\018\000\
    \029\000\031\000\031\000\051\000\031\000\031\000\052\000\013\000\
    \009\000\020\000\024\000\053\000\058\000\060\000\063\000\049\000\
    \062\000\064\000\060\000\073\000\070\000\072\000\074\000\075\000\
    \031\000\076\000\031\000\077\000\078\000\079\000\080\000\031\000\
    \031\000\113\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\063\000\031\000\087\000\031\000\064\000\084\000\
    \117\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\082\000\084\000\082\000\255\255\031\000\
    \255\255\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\038\000\031\000\095\000\255\255\
    \255\255\095\000\038\000\038\000\255\255\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\106\000\
    \255\255\255\255\106\000\255\255\255\255\095\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \000\000\081\000\115\000\059\000\038\000\065\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \043\000\043\000\061\000\062\000\085\000\061\000\043\000\043\000\
    \043\000\043\000\043\000\043\000\043\000\043\000\043\000\043\000\
    \043\000\086\000\083\000\116\000\089\000\083\000\092\000\063\000\
    \118\000\061\000\064\000\060\000\066\000\066\000\066\000\066\000\
    \066\000\066\000\066\000\066\000\066\000\066\000\119\000\093\000\
    \061\000\083\000\093\000\097\000\255\255\255\255\097\000\085\000\
    \031\000\083\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\086\000\093\000\255\255\
    \255\255\255\255\255\255\255\255\087\000\255\255\255\255\084\000\
    \255\255\097\000\255\255\097\000\255\255\061\000\089\000\255\255\
    \092\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\083\000\255\255\255\255\
    \255\255\107\000\255\255\082\000\255\255\107\000\255\255\107\000\
    \107\000\255\255\107\000\107\000\107\000\107\000\107\000\107\000\
    \107\000\107\000\107\000\107\000\255\255\255\255\255\255\107\000\
    \255\255\255\255\093\000\107\000\107\000\107\000\107\000\107\000\
    \107\000\107\000\107\000\107\000\107\000\107\000\107\000\107\000\
    \107\000\107\000\107\000\107\000\107\000\107\000\107\000\107\000\
    \107\000\107\000\107\000\107\000\107\000\255\255\255\255\255\255\
    \255\255\107\000\255\255\107\000\107\000\107\000\107\000\107\000\
    \107\000\107\000\107\000\107\000\107\000\107\000\107\000\107\000\
    \107\000\107\000\107\000\107\000\107\000\107\000\107\000\107\000\
    \107\000\107\000\107\000\107\000\107\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \115\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\085\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\086\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\116\000\089\000\255\255\092\000\255\255\118\000\255\255\
    \255\255\061\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\119\000\255\255\255\255\255\255\
    \255\255\083\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\097\000\111\000\255\255\255\255\255\255\111\000\255\255\
    \111\000\111\000\255\255\111\000\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\255\255\255\255\255\255\
    \111\000\255\255\107\000\255\255\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\111\000\255\255\255\255\
    \255\255\255\255\111\000\255\255\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\111\000\112\000\255\255\
    \255\255\255\255\112\000\255\255\112\000\112\000\255\255\112\000\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\255\255\255\255\255\255\112\000\255\255\255\255\255\255\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\255\255\255\255\255\255\255\255\112\000\255\255\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\120\000\255\255\255\255\255\255\120\000\255\255\
    \120\000\120\000\255\255\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\255\255\255\255\255\255\
    \120\000\255\255\255\255\255\255\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\255\255\255\255\
    \255\255\255\255\120\000\255\255\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255";
  Lexing.lex_base_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\084\000\
    \168\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \252\000";
  Lexing.lex_backtrk_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\007\000\000\000\000\000\015\000\
    \000\000";
  Lexing.lex_default_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000";
  Lexing.lex_trans_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\010\000\
    \000\000\000\000\000\000\000\000\000\000\010\000\010\000\000\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\000\000\004\000\000\000\000\000\010\000\
    \000\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\000\000\000\000\000\000\000\000\
    \000\000\010\000\010\000\000\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\000\000\
    \000\000\000\000\000\000\010\000\000\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \000\000\000\000\000\000\000\000\000\000\010\000\010\000\000\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\000\000\000\000\000\000\000\000\010\000\
    \000\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\000\000\000\000\000\000\000\000\
    \000\000\010\000\010\000\000\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\000\000\
    \000\000\000\000\000\000\010\000\000\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
    \010\000\010\000\010\000\010\000\010\000\010\000\010\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_check_code =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\107\000\
    \255\255\255\255\255\255\255\255\255\255\107\000\107\000\255\255\
    \107\000\107\000\107\000\107\000\107\000\107\000\107\000\107\000\
    \107\000\107\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\107\000\107\000\107\000\107\000\107\000\107\000\107\000\
    \107\000\107\000\107\000\107\000\107\000\107\000\107\000\107\000\
    \107\000\107\000\107\000\107\000\107\000\107\000\107\000\107\000\
    \107\000\107\000\107\000\255\255\093\000\255\255\255\255\107\000\
    \255\255\107\000\107\000\107\000\107\000\107\000\107\000\107\000\
    \107\000\107\000\107\000\107\000\107\000\107\000\107\000\107\000\
    \107\000\107\000\107\000\107\000\107\000\107\000\107\000\107\000\
    \107\000\107\000\107\000\111\000\255\255\255\255\255\255\255\255\
    \255\255\111\000\111\000\255\255\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\111\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\111\000\111\000\255\255\
    \255\255\255\255\255\255\111\000\255\255\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\111\000\111\000\111\000\
    \111\000\111\000\111\000\111\000\111\000\111\000\111\000\112\000\
    \255\255\255\255\255\255\255\255\255\255\112\000\112\000\255\255\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\112\000\255\255\255\255\255\255\255\255\112\000\
    \255\255\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
    \112\000\112\000\112\000\120\000\255\255\255\255\255\255\255\255\
    \255\255\120\000\120\000\255\255\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\255\255\
    \255\255\255\255\255\255\120\000\255\255\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\120\000\
    \120\000\120\000\120\000\120\000\120\000\120\000\120\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255";
  Lexing.lex_code =
   "\255\000\255\255\001\255\255\000\001\255\002\255\001\255\255\000\
    \002\255";
}

let rec is_test lexbuf =
   __ocaml_lex_is_test_rec lexbuf 0
and __ocaml_lex_is_test_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 35 "ocamltest/tsl_lexer.mll"
            ( is_test lexbuf )
# 502 "ocamltest/tsl_lexer.ml"

  | 1 ->
# 36 "ocamltest/tsl_lexer.mll"
            ( Lexing.new_line lexbuf; is_test lexbuf )
# 507 "ocamltest/tsl_lexer.ml"

  | 2 ->
# 37 "ocamltest/tsl_lexer.mll"
                       ( true )
# 512 "ocamltest/tsl_lexer.ml"

  | 3 ->
# 38 "ocamltest/tsl_lexer.mll"
                             ( true )
# 517 "ocamltest/tsl_lexer.ml"

  | 4 ->
# 39 "ocamltest/tsl_lexer.mll"
                       ( true )
# 522 "ocamltest/tsl_lexer.ml"

  | 5 ->
# 40 "ocamltest/tsl_lexer.mll"
                             ( true )
# 527 "ocamltest/tsl_lexer.ml"

  | 6 ->
# 41 "ocamltest/tsl_lexer.mll"
      ( false )
# 532 "ocamltest/tsl_lexer.ml"

  | 7 ->
# 42 "ocamltest/tsl_lexer.mll"
        ( false )
# 537 "ocamltest/tsl_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_is_test_rec lexbuf __ocaml_lex_state

and token lexbuf =
   __ocaml_lex_token_rec lexbuf 31
and __ocaml_lex_token_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 45 "ocamltest/tsl_lexer.mll"
            ( token lexbuf )
# 549 "ocamltest/tsl_lexer.ml"

  | 1 ->
# 46 "ocamltest/tsl_lexer.mll"
            ( Lexing.new_line lexbuf; token lexbuf )
# 554 "ocamltest/tsl_lexer.ml"

  | 2 ->
# 47 "ocamltest/tsl_lexer.mll"
                       ( TSL_BEGIN_C_STYLE `Above )
# 559 "ocamltest/tsl_lexer.ml"

  | 3 ->
# 48 "ocamltest/tsl_lexer.mll"
                                                    (
      let s = Lexing.lexeme lexbuf in
      String.iter (fun c -> if c = '\n' then Lexing.new_line lexbuf) s;
      TSL_BEGIN_C_STYLE `Below
    )
# 568 "ocamltest/tsl_lexer.ml"

  | 4 ->
# 53 "ocamltest/tsl_lexer.mll"
         ( TSL_END_C_STYLE )
# 573 "ocamltest/tsl_lexer.ml"

  | 5 ->
# 54 "ocamltest/tsl_lexer.mll"
                       ( TSL_BEGIN_OCAML_STYLE `Above )
# 578 "ocamltest/tsl_lexer.ml"

  | 6 ->
# 55 "ocamltest/tsl_lexer.mll"
                                                    (
      let s = Lexing.lexeme lexbuf in
      String.iter (fun c -> if c = '\n' then Lexing.new_line lexbuf) s;
      TSL_BEGIN_OCAML_STYLE `Below
    )
# 587 "ocamltest/tsl_lexer.ml"

  | 7 ->
# 60 "ocamltest/tsl_lexer.mll"
         ( TSL_END_OCAML_STYLE )
# 592 "ocamltest/tsl_lexer.ml"

  | 8 ->
# 61 "ocamltest/tsl_lexer.mll"
        ( COMMA )
# 597 "ocamltest/tsl_lexer.ml"

  | 9 ->
# 62 "ocamltest/tsl_lexer.mll"
         ( TEST_DEPTH (String.length (Lexing.lexeme lexbuf)) )
# 602 "ocamltest/tsl_lexer.ml"

  | 10 ->
let
# 63 "ocamltest/tsl_lexer.mll"
                 n
# 608 "ocamltest/tsl_lexer.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 1) lexbuf.Lexing.lex_curr_pos in
# 63 "ocamltest/tsl_lexer.mll"
                    ( TEST_DEPTH (int_of_string n))
# 612 "ocamltest/tsl_lexer.ml"

  | 11 ->
# 64 "ocamltest/tsl_lexer.mll"
         ( PLUSEQUAL )
# 617 "ocamltest/tsl_lexer.ml"

  | 12 ->
# 65 "ocamltest/tsl_lexer.mll"
        ( EQUAL )
# 622 "ocamltest/tsl_lexer.ml"

  | 13 ->
# 67 "ocamltest/tsl_lexer.mll"
    ( let s = Lexing.lexeme lexbuf in
      match s with
        | "include" -> INCLUDE
        | "set" -> SET
        | "unset" -> UNSET
        | "with" -> WITH
        | _ -> IDENTIFIER s
    )
# 634 "ocamltest/tsl_lexer.ml"

  | 14 ->
# 75 "ocamltest/tsl_lexer.mll"
        ( LEFT_BRACE )
# 639 "ocamltest/tsl_lexer.ml"

  | 15 ->
# 76 "ocamltest/tsl_lexer.mll"
        ( RIGHT_BRACE )
# 644 "ocamltest/tsl_lexer.ml"

  | 16 ->
# 77 "ocamltest/tsl_lexer.mll"
        ( SEMI )
# 649 "ocamltest/tsl_lexer.ml"

  | 17 ->
# 79 "ocamltest/tsl_lexer.mll"
    (
      comment_start_pos := [Lexing.lexeme_start_p lexbuf];
      has_comments := true;
      comment lexbuf
    )
# 658 "ocamltest/tsl_lexer.ml"

  | 18 ->
# 85 "ocamltest/tsl_lexer.mll"
    ( STRING (string "" lexbuf) )
# 663 "ocamltest/tsl_lexer.ml"

  | 19 ->
# 87 "ocamltest/tsl_lexer.mll"
    (
      let pos = Lexing.lexeme_start_p lexbuf in
      let file = pos.Lexing.pos_fname in
      let line = pos.Lexing.pos_lnum in
      let column = pos.Lexing.pos_cnum - pos.Lexing.pos_bol in
      let message = Printf.sprintf "%s:%d:%d: unexpected character %s"
        file line column (Lexing.lexeme lexbuf) in
      lexer_error message
    )
# 676 "ocamltest/tsl_lexer.ml"

  | 20 ->
# 97 "ocamltest/tsl_lexer.mll"
    ( lexer_error "unexpected eof" )
# 681 "ocamltest/tsl_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_token_rec lexbuf __ocaml_lex_state

and string acc lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 2 (-1); __ocaml_lex_string_rec acc lexbuf 89
and __ocaml_lex_string_rec acc lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 110 "ocamltest/tsl_lexer.mll"
    ( string (acc ^ Lexing.lexeme lexbuf) lexbuf )
# 693 "ocamltest/tsl_lexer.ml"

  | 1 ->
let
# 111 "ocamltest/tsl_lexer.mll"
                                        blank
# 699 "ocamltest/tsl_lexer.ml"
= Lexing.sub_lexeme_char_opt lexbuf lexbuf.Lexing.lex_mem.(0) in
# 112 "ocamltest/tsl_lexer.mll"
    ( let space =
        match blank with None -> "" | Some blank -> String.make 1 blank
      in
      Lexing.new_line lexbuf;
      string (acc ^ space) lexbuf )
# 707 "ocamltest/tsl_lexer.ml"

  | 2 ->
# 118 "ocamltest/tsl_lexer.mll"
    (string (acc ^ "\\") lexbuf)
# 712 "ocamltest/tsl_lexer.ml"

  | 3 ->
# 120 "ocamltest/tsl_lexer.mll"
    (acc)
# 717 "ocamltest/tsl_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_string_rec acc lexbuf __ocaml_lex_state

and comment lexbuf =
   __ocaml_lex_comment_rec lexbuf 97
and __ocaml_lex_comment_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 123 "ocamltest/tsl_lexer.mll"
    (
      comment_start_pos :=
        (Lexing.lexeme_start_p lexbuf) :: !comment_start_pos;
      comment lexbuf
    )
# 733 "ocamltest/tsl_lexer.ml"

  | 1 ->
# 129 "ocamltest/tsl_lexer.mll"
    (
      comment_start_pos := List.tl !comment_start_pos;
      if !comment_start_pos = [] then token lexbuf else comment lexbuf
    )
# 741 "ocamltest/tsl_lexer.ml"

  | 2 ->
# 134 "ocamltest/tsl_lexer.mll"
    (
      let pos = List.hd !comment_start_pos in
      let file = pos.Lexing.pos_fname in
      let line = pos.Lexing.pos_lnum in
      let column = pos.Lexing.pos_cnum - pos.Lexing.pos_bol in
      let message = Printf.sprintf "%s:%d:%d: unterminated comment"
        file line column in
      lexer_error message
    )
# 754 "ocamltest/tsl_lexer.ml"

  | 3 ->
# 144 "ocamltest/tsl_lexer.mll"
    (
      Lexing.new_line lexbuf;
      comment lexbuf
    )
# 762 "ocamltest/tsl_lexer.ml"

  | 4 ->
# 149 "ocamltest/tsl_lexer.mll"
    (
      comment lexbuf
    )
# 769 "ocamltest/tsl_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_comment_rec lexbuf __ocaml_lex_state

and modifier lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 3 (-1);(* L=2 [2] <- p ; [1] <- p ;  *)
  lexbuf.Lexing.lex_mem.(2) <- lexbuf.Lexing.lex_curr_pos ;
  lexbuf.Lexing.lex_mem.(1) <- lexbuf.Lexing.lex_curr_pos ;
 __ocaml_lex_modifier_rec lexbuf 107
and __ocaml_lex_modifier_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 155 "ocamltest/tsl_lexer.mll"
                       variable
# 785 "ocamltest/tsl_lexer.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 1) lexbuf.Lexing.lex_curr_pos in
# 156 "ocamltest/tsl_lexer.mll"
    ( variable, `Remove )
# 789 "ocamltest/tsl_lexer.ml"

  | 1 ->
let
# 157 "ocamltest/tsl_lexer.mll"
                   variable
# 795 "ocamltest/tsl_lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0)
and
# 157 "ocamltest/tsl_lexer.mll"
                                          str
# 800 "ocamltest/tsl_lexer.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_mem.(0) + 2) (lexbuf.Lexing.lex_curr_pos + -1) in
# 158 "ocamltest/tsl_lexer.mll"
    ( variable, `Add str )
# 804 "ocamltest/tsl_lexer.ml"

  | 2 ->
let
# 159 "ocamltest/tsl_lexer.mll"
                   variable
# 810 "ocamltest/tsl_lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0)
and
# 159 "ocamltest/tsl_lexer.mll"
                                           str
# 815 "ocamltest/tsl_lexer.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_mem.(0) + 3) (lexbuf.Lexing.lex_curr_pos + -1) in
# 160 "ocamltest/tsl_lexer.mll"
    ( variable, `Append str )
# 819 "ocamltest/tsl_lexer.ml"

  | 3 ->
# 162 "ocamltest/tsl_lexer.mll"
    ( failwith "syntax error in script response file" )
# 824 "ocamltest/tsl_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_modifier_rec lexbuf __ocaml_lex_state

;;

